<# :
@echo off
setlocal
cd /d "%~dp0"
openfiles >nul 2>&1
if %errorlevel% neq 0 (
    powershell -Command "Start-Process -FilePath '%0' -Verb RunAs"
    exit /b
)
powershell -NoProfile -ExecutionPolicy Bypass -Command "iex ((Get-Content -LiteralPath '%~f0') -join \"`n\")"
pause
exit /b
#>

# --- POWERSHELL CLEANUP CODE STARTS HERE ---
Write-Host "--- GigaTribe Deep Cleanup ---" -ForegroundColor Cyan

#
# 1. Kill active processes
#
Write-Host "Closeing any GigaTribe still running" -ForegroundColor Cyan
Stop-Process -Name "GigaTribe" -Force -ErrorAction SilentlyContinue
$processName = "GigaTribe"
Get-Process | Where-Object { $_.Name -like "*$processName*" } | Stop-Process -Force -ErrorAction SilentlyContinue

#
# 2. Identify Installation Directories
#
$possibleInstallDirs = @("${env:ProgramFiles(x86)}\GigaTribe", "$env:ProgramFiles\GigaTribe")

#
# 3. Handle Uninstallation (Newer QTIFW Version or Older Inno Setup) — try both install locations
#
foreach ($installDir in $possibleInstallDirs) {
    if (Test-Path $installDir) {
        if (Test-Path "$installDir\maintenancetool.exe") {
            Write-Host "Detected Newer Version (Qt Framework) in $installDir. Running Maintenance Tool..." -ForegroundColor Cyan
            # --confirm-command purge is the silent uninstall command for QTIFW
            Start-Process -FilePath "$installDir\maintenancetool.exe" -ArgumentList "--confirm-command purge" -Wait
        }
        elseif (Test-Path "$installDir\unins000.exe") {
            Write-Host "Detected Older Version (Inno Setup) in $installDir. Running Uninstaller..." -ForegroundColor Cyan
            Start-Process -FilePath "$installDir\unins000.exe" -ArgumentList "/VERYSILENT /SUPPRESSMSGBOXES" -Wait
        }
        else {
            Write-Host "No uninstaller found in $installDir. Will attempt manual removal later." -ForegroundColor Yellow
        }
    }
}

#
# 4. Dynamic Registry Scanner (Finds GUIDs & Qt MaintenanceTool)
#
$UninstallHives = @(
    "HKLM:\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall",
    "HKLM:\SOFTWARE\WOW6432Node\Microsoft\Windows\CurrentVersion\Uninstall",
    "HKCU:\Software\Microsoft\Windows\CurrentVersion\Uninstall"
)
foreach ($Hive in $UninstallHives) {
    if (Test-Path $Hive) {
        Get-ChildItem -Path $Hive | ForEach-Object {
            $prop = Get-ItemProperty $_.PSPath -ErrorAction SilentlyContinue
            if ($prop.DisplayName -like "*GigaTribe*") {
                Write-Host "Found: $($prop.DisplayName)" -ForegroundColor Yellow
                if ($prop.UninstallString -like "*maintenancetool*") {
                    $cleanPath = $prop.UninstallString -replace '"', ''
                    Start-Process -FilePath $cleanPath -ArgumentList "--confirm-command purge" -Wait -NoNewWindow -ErrorAction SilentlyContinue
                }
                Remove-Item -Path $_.PSPath -Recurse -Force -ErrorAction SilentlyContinue
            }
        }
    }
}

#
# 5. Clean up Registry Keys
#
$RegKeys = @(
    "HKCU:\Software\Shalsoft",
    "HKCU:\Software\Shalit",
    "HKLM:\SOFTWARE\WOW6432Node\Microsoft\Windows\CurrentVersion\Uninstall\GigaTribe",
    "HKLM:\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\GigaTribe_is1"
)
foreach ($key in $RegKeys) {
    if (Test-Path $key) {
        Remove-Item -Path $key -Recurse -Force
        Write-Host "Removed Registry Key: $key" -ForegroundColor Yellow
    }
}

#
# 6. Target System & AppData Folders
#
$Folders = @(
    "${env:ProgramFiles}\GigaTribe",
    "${env:ProgramFiles(x86)}\GigaTribe",
    "$env:AppData\GigaTribe",
    "$env:LocalAppData\Shalsoft",
    "$env:LocalAppData\GigaTribe"
)
foreach ($Path in $Folders) {
    if (Test-Path $Path) {
        Remove-Item -Path $Path -Recurse -Force -ErrorAction SilentlyContinue
        Write-Host "Removed folder: $Path" -ForegroundColor Yellow
    }
}

#
# 7. Clean up partial downloads in localized "Documents" folder
# This finds the 'Documents' path even if it's renamed or moved to another drive
#
$docsPath = [Environment]::GetFolderPath("MyDocuments")
if (Test-Path $docsPath) {
    Write-Host "Searching for GigaTribe download folders in: $docsPath" -ForegroundColor Cyan
    # Search for any directory in Documents containing "GigaTribe"
    $gtFolders = Get-ChildItem -Path $docsPath -Directory -Filter "*GigaTribe*" -ErrorAction SilentlyContinue
    
    foreach ($dir in $gtFolders) {
        Write-Host "Nuking partials in: $($dir.Name)" -ForegroundColor Yellow
        Get-ChildItem -Path $dir.FullName -Include "*.downloading", "*.downloading.state" -Recurse -File -ErrorAction SilentlyContinue | Remove-Item -Force
    }
}

#
# 8. Remove firewall rules
#
Write-Host "Removing Firewall Rules..." -ForegroundColor Gray
netsh advfirewall firewall delete rule name="GigaTribe" > $null

Write-Host "`nCleanup Complete! Ready for a fresh start." -ForegroundColor Green
Write-Host "`nhttps://www.gigatribe.com/" -ForegroundColor Blue